require("scripts/chocshopstyle.lua");


--------------------------------WORLD MAP
CSMapNameStyle = {
	font = { edwardian_medium, 22, WhiteColor },
	flags = kVAlignTop + kHAlignLeft,
	outline = {Color(93,67,37), 3},
	layer = -1,
};

CSMapLocStyle = { 
	font = { edwardian_medium, 18, WhiteColor },
	flags = kVAlignTop + kHAlignLeft,
	outline = {Color(93,67,37), 3},
	layer = -1,
};

ScoreColor = Color(250,250,250);
ShadowColor = Color(0,0,0);
MasteryColor = Color(225, 189, 46);--Color(195,159,16);
MasteryShadow = ShadowColor;
GoalColor = Color(92,183,39);
GoalShadow = ShadowColor;
BestColor = Color(0, 198, 255);--Color(192,61,102);
BestShadow = ShadowColor;

shadowX = 2.5;
shadowY = 1;

CSMapScoreBoxStyle = {
    baseDir = "ui/backgrounds/",
    w = 130, h = 110,
    x1 = 30, y1 = 32,
    x2 = 37, y2 = 40,
    mouse = false,
    assets = {
        background = {
            { state="default", file="split9_dialog_small", anim=false },
        },
    },
    text = {
        bold = true,
        level = {
            x = 0, y = 10, w = 120, h = 20,
            font = { edwardian_medium, 17, ScoreColor },
            flags = kVAlignTop + kHAlignCenter,
            --outline = {BlackColor, 1},
            shadow = {shadowX,shadowY,ShadowColor},
        },
        best_label = {
            x = 0, y = 30, w = 67, h = 20,
            font = { edwardian_medium, 17, BestColor },
            flags = kVAlignTop + kHAlignRight,
            --outline = {Color(192,61,102), 1},
            shadow = {shadowX,shadowY,BestShadow},
            label = "map_best",
        },
        best = {
            x = 67, y = 30, w = 63, h = 20,
            font = { edwardian_medium, 17, BestColor },
            flags = kVAlignTop + kHAlignLeft,
            --outline = {Color(192,61,102), 1},
            shadow = {shadowX,shadowY,BestShadow},
        },
        goal_label = {
            x = 0, y = 50, w = 67, h = 20,
            font = { edwardian_medium, 17, GoalColor },
            flags = kVAlignTop + kHAlignRight,
            --outline = {Color(92,113,39), 1},
            shadow = {shadowX,shadowY,GoalShadow},
            label = "map_goal",
        },
        goal = {
            x = 67, y = 50, w = 63, h = 20,
            font = { edwardian_medium, 17, GoalColor },
            flags = kVAlignTop + kHAlignLeft,
            --outline = {Color(92,113,39), 1},
            shadow = {shadowX,shadowY,GoalShadow},
        },
        mastery_label = {
            x = 0, y = 70, w = 67, h = 20,
            font = { edwardian_medium, 17, MasteryColor },
            flags = kVAlignTop + kHAlignRight,
            --outline = {Color(115,79,16), 1},
            shadow = {shadowX,shadowY,MasteryShadow},
            label = "map_mastery",
        },
        mastery = {
            x = 67, y = 70, w = 63, h = 20,
            font = { edwardian_medium, 17, MasteryColor },
            flags = kVAlignTop + kHAlignLeft,
            --outline = {Color(115,79,16), 1},
            shadow = {shadowX,shadowY,MasteryShadow},
        },
    },
};

map_globe_assets = {
	none = {
		{state="default", file="globe_grey", anim=false},
	},
	mastered = {
		{state="default", file="globe_gold", anim=false},
		{state="over", file="globe_gold_over", anim=false},
	},
	current = {
		{state="default", file="globe_pink", anim=false},
		{state="over", file="globe_pink_over", anim=false},
	},
	cleared = {
		{state="default", file="globe_green", anim=false},
		{state="over", file="globe_green_over", anim=false},
	}
};

map_globe_style = {
    sound = "audio/sfx/buttonclick.ogg",
    assets = map_globe_assets,
};

map_pin_assets = {
	base = {
	    {state="disabled", file = "pin_disabled" },
		{state="enabled", file = "anim_pin", base=0}
	},
	closed = {
		{state="disabled", file = "pin_disabled", anim=false},
		{state="enabled", file = "pin_enabled", anim=false}
	}
};

map_pin_children = {
    font = { edwardian_medium, 18, BlackColor },
	globe_01 = {
		x = 72, y = 22,
		id = 0,
		style = map_globe_style,
	},
	globe_02 = {
		x = 102, y = 34,
		id = 1,
		style = map_globe_style,
	},
	globe_03 = {
		x = 120, y = 61,
		id = 2,
		style = map_globe_style,
	},
	globe_04 = {
		x = 119, y = 93,
		id = 3,
		style = map_globe_style,
	},
	globe_05 = {
		x = 98, y = 118,
		id = 4,
		style = map_globe_style,
	},
	globe_06 = {
		x = 67, y = 127,
		id = 5,
		style = map_globe_style,
	},
	globe_07 = {
		x = 37, y = 115,
		id = 6,
		style = map_globe_style,
	},
	globe_08 = {
		x = 19, y = 88,
		id = 7,
		style = map_globe_style,
	},
	globe_09 = {
		x = 21, y = 57,
		id = 8,
		style = map_globe_style,
	},
	globe_10 = {
		x = 41, y = 30,
		id = 9,
		style = map_globe_style,
	}
}

map_pins = {
	baseDir = "ui/map/",
	iquitos = {
	    spriteLayer = 1,
		x = 144, y = 361,
		movex = -10, movey = 35,
		baseLevel = 1,
		box = {
		    x = 75, y = -60,
		    style = CSMapScoreBoxStyle,
		},
		assets = map_pin_assets,
		globes = map_pin_children,
		text = {
		    name = {
			    x = -76, y = -25, w = 200, h = 50,
			    style = CSMapNameStyle,
			    label = "map_name_iquitos",
		    },
		    loc = {
			    x = -76, y = -5, w = 200, h = 50,
			    style = CSMapLocStyle,
			    label = "map_loc_iquitos",
		    }
		}
	},
	grytviken = {
	    spriteLayer = 1,
		x = 213, y = 500,
		movex = 40, movey = 0,
		baseLevel = 11,
		box = {
		    x = 75, y = -150,
		    style = CSMapScoreBoxStyle,
		},
		assets = map_pin_assets,
		globes = map_pin_children,
		text = {
		    name = {
			    x = 30, y = -45, w = 300, h = 50,
			    style = CSMapNameStyle,
			    label = "map_name_grytviken",
		    },
		    loc = {
			    x = 30, y = -25, w = 300, h = 50,
			    style = CSMapLocStyle,
			    label = "map_loc_grytviken",
		    }
		}
	},
	namche = {
	    spriteLayer = 1,
		x = 513, y = 278,
		movex = 40, movey = 0,
		baseLevel = 21,
		box = {
		    x = -170, y = -20,
		    style = CSMapScoreBoxStyle,
		},
		assets = map_pin_assets,
		globes = map_pin_children,
		text = {
		    name = {
			    x = 30, y = -45, w = 200, h = 50,
			    style = CSMapNameStyle,
			    label = "map_name_namche",
		    },
		    loc = {
			    x = 30, y = -25, w = 200, h = 50,
			    style = CSMapLocStyle,
			    label = "map_loc_namche",
		    }
		}
	},
	krakatoa = {
	    spriteLayer = 1,
		x = 541, y = 370,
		movex = -10, movey = 35,
		baseLevel = 31,
		box = {
		    x = 75, y = -60,
		    style = CSMapScoreBoxStyle,
		},
		assets = map_pin_assets,
		globes = map_pin_children,
		text = {
		    name = {
			    x = -100, y = -25, w = 200, h = 50,
			    style = CSMapNameStyle,
			    label = "map_name_krakatoa",
		    },
		    loc = {
			    x = -100, y = -5, w = 200, h = 50,
			    style = CSMapLocStyle,
			    label = "map_loc_krakatoa",
		    }
		}
	},
	kamchatka = {
	    spriteLayer = 1,
		x = 666, y = 204,
		movex = -45, movey = 0,
		baseLevel = 41,
		box = {
		    x = 0, y = 20,
		    style = CSMapScoreBoxStyle,
		},
		assets = map_pin_assets,
		globes = map_pin_children,
		text = {
		    name = {
			    x = -125, y = -70, w = 200, h = 50,
			    style = CSMapNameStyle,
			    label = "map_name_kamchatka",
		    },
		    loc = {
			    x = -125, y = -50, w = 200, h = 50,
			    style = CSMapLocStyle,
			    label = "map_loc_kamchatka",
		    }
	    }
	},
	gaberoun = {
	    spriteLayer = 1,
		x = 334, y = 298,
		movex = 0, movey = -50,
		baseLevel = 51,
		box = {
		    x = -190, y = -105,
		    style = CSMapScoreBoxStyle,
		},
		assets = map_pin_assets,
		globes = map_pin_children,
		text = {
		    name = {
			    x = -77, y = -95, w = 200, h = 50,
			    style = CSMapNameStyle,
			    label = "map_name_gaberoun",
		    },
		    loc = {
			    x = -77, y = -75, w = 200, h = 50,
			    style = CSMapLocStyle,
			    label = "map_loc_gaberoun",
		    }
		}
	},
}